import matplotlib.pyplot as plt
import numpy as np
import subfunctions as sf

rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}}
planet = {'g': 3.72}

omega_in = np.linspace(0, 3.9)
torque_in = sf.tau_dcmotor(omega_in, rover['wheel_assembly']['motor'])
Ng = sf.get_gear_ratio(rover['wheel_assembly']['speed_reducer'])
torque = Ng * torque_in
omega = omega_in / Ng
power = torque * omega

figure, axis = plt.subplots(3)
axis[0].plot(torque, omega)
axis[0].set_title('Output Speed vs Output Shaft Torque')
axis[0].set_xlabel('Output Shaft Torque (Nm)')
axis[0].set_ylabel('Output Speed (rad/s)')

axis[1].plot(torque, power)
axis[1].set_title('Output Power vs Output Shaft Torque')
axis[1].set_xlabel('Output Shaft Torque (Nm)')
axis[1].set_ylabel('Output Power (W)')

axis[2].plot(omega, power)
axis[2].set_title('Output Power vs Output Speed')
axis[2].set_xlabel('Output Speed (rad/s)')
axis[2].set_ylabel('Output Power (W)')
figure.tight_layout(pad=1.5)    #This is to increase the space between the graphs
plt.show()